% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program Weibullcostfunc.m
function L = Weibullcostfunc(guess, data)

tau = guess(1);
eta = guess(2);
Nconditions = size(data, 2); % # of stimulus conditions
xi = 0.50;
lamda = 0.02;
L=0;

for i=1:Nconditions
    p = xi + (1 - xi - lamda)*(1-exp(-(data(1,i)/tau).^eta));
        % Eq. 10.15
    if (p < 1/2/(data(2, i)+data(3, i)))    
        % putting lower and upper boundaries on p
        p = 1/2/(data(2, i)+data(3, i));
    elseif (p> 1-1/2/(data(2, i)+data(3, i)))
        p = 1- 1/2/(data(2, i)+data(3, i));
    end
    L = L - (data(2, i)*log(p) + data(3, i)*log(1-p));
end
